/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: EcatSoEIDN_Functionlist.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    Ecat SoE IDN
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
      1        05.05.2009  SB       1.000
        Created

**************************************************************************************/
#ifndef __ECAT_SOEIDN_FUNCTIONLIST_H
#define __ECAT_SOEIDN_FUNCTIONLIST_H



/***************************************************************************************/
/* Ecat SoE IDN function list, prototyes */

TLR_RESULT
TaskExit_EcatSoEIDN(  void* pvRsc);

TLR_RESULT
TaskLeave_EcatSoEIDN( void* pvRsc,
                      void* pvLve);

void
TaskEnter_EcatSoEIDN( void* pvInit);

/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ECAT_SOE_IDN_STARTUP_PARAM_VERSION (1)

#ifndef TLR_TASK_ECAT_SOE_IDN
#define TLR_TASK_ECAT_SOE_IDN            ((TLR_TASKIDENTIFIER)0x00220002L)
#endif

/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** type of <code>ECAT_SOE_IDN_STARTUPPARAMETER_Ttag</code> */
typedef struct ECAT_SOE_IDN_STARTUPPARAMETER_Ttag  ECAT_SOE_IDN_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct ECAT_SOE_IDN_STARTUPPARAMETER_Ttag    /* Task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
};

/** @} */

/***************************************************************************************/
#endif /* #ifndef __ECAT_SOEIDN_FUNCTIONLIST_H */
